#include "ulamek.h"

inline double ulamek::to_double() const
    {
    return licznik/(double)mianownik;
    }
char* ulamek::to_string() const
    {
    char str_licznik[ulamek_maxstr]; itoa(licznik,str_licznik,10);
    char str_mianownik[ulamek_maxstr]; itoa(mianownik,str_mianownik,10);
    char* str=str_licznik;
    strcat(str,"/");
    strcat(str,str_mianownik);
    return str;
    }
void ulamek::set(int alicznik,int amianownik)
    {
    if (amianownik==0) throw "Ulamek: Blad #1";
    licznik=alicznik;
    mianownik=amianownik;
    }
void ulamek::simplify()
    {
    //NWD
    int mniejsza=(abs(licznik)<abs(mianownik))?abs(licznik):abs(mianownik);
    for(int i=mniejsza;i>0;i--)
        if ((licznik%i==0) && (mianownik%i==0))
                {
                licznik/=i;
                mianownik/=i;
                }
            //znaki
        if (licznik*mianownik<0)
                {
                licznik=-abs(licznik);
                mianownik=abs(mianownik);
                }
                else
                {
                licznik=abs(licznik);
                mianownik=abs(mianownik);
                }
         }
inline void ulamek::get(int& rlicznik,int& rmianownik) const
    {
    rlicznik=licznik;
    rmianownik=mianownik;
    }
inline void ulamek::get(int* plicznik,int* pmianownik) const
    {
    *plicznik=licznik;
    *pmianownik=mianownik;
    }


ulamek operator *(const ulamek& aulamek1,const ulamek& aulamek2)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    int alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return ulamek(alicznik1*alicznik2,amianownik1*amianownik2);
    };
ulamek operator /(const ulamek& aulamek1,const ulamek& aulamek2)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    int alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return ulamek(alicznik1*amianownik2,amianownik1*alicznik2);
    };
ulamek operator +(const ulamek& aulamek1,const ulamek& aulamek2)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    int alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return ulamek(alicznik1*amianownik2+alicznik2*amianownik1,amianownik1*amianownik2);
    };
ulamek operator -(const ulamek& aulamek1)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    return ulamek(-alicznik1,amianownik1);
    };
ulamek operator -(const ulamek& aulamek1,const ulamek& aulamek2)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    int alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return ulamek(alicznik1*amianownik2-alicznik2*amianownik1,amianownik1*amianownik2);
    };
bool operator <(const ulamek& aulamek1,const ulamek& aulamek2)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    int alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return (alicznik1/(double)amianownik1)<(alicznik2/(double)amianownik2);
    };
bool operator >(const ulamek& aulamek1,const ulamek& aulamek2)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    int alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return (alicznik1/(double)amianownik1)>(alicznik2/(double)amianownik2);
    };
bool operator ==(const ulamek& aulamek1,const ulamek& aulamek2)
    {
    int alicznik1=0,amianownik1=1;aulamek1.get(alicznik1,amianownik1);
    int alicznik2=0,amianownik2=1;aulamek2.get(alicznik2,amianownik2);
    return (alicznik1/(double)amianownik1)==(alicznik2/(double)amianownik2);
    };
